package controller

import (
	"time"
)

type Upload struct {
	Content    string    `json:"Content" form:"Content" query:"Content"`
	Passwd     string    `json:"Passwd" form:"Passwd" query:"Passwd"`
	Name       string    `json:"Name" form:"Name" query:"Name"`
	Type       string    `json:"Type" form:"Type" query:"Type"`
	HighLight  bool      `json:"HighLight" form:"HighLight" query:"HighLight"`
	Expiration time.Time `json:"Expiration" form:"Expiration" query:"Expiration"`
	MaxAge     int       `json:"MaxAge" form:"MaxAge" query:"MaxAge"`    // 用户指定的时间期限
	MaxView    uint      `json:"MaxView" form:"MaxView" query:"MaxView"` // 文件最大可访问次数
	//Expiry     time.Time `json:"expiry"` // 有效期
	//Content string `json:"content"`
}

type Download struct {
	Passwd string `json:"Passwd" form:"Passwd" query:"Passwd"`
	Url    string `json:"Url" form:"Url" query:"Url"`
}

type Msg struct {
	Name    string
	Type    string
	Content string
}

type Msg2 struct {
	Url  string
	Name string
	Size int
}

// 从config文件获取
type Setting struct {
	Url            string // 配置的域名
	MaxDefaultView int    // 单文件默认最大可访问次数
	MaxSize        int    // 文件最大可上传大小（单位B）
}

var Settings Setting
