package app

import (
	"backend/app/controller"
	"backend/app/middleware"
	//"backend/model"
)

func addRoutes() {
	api := e.Group("api")
	api.Use(middleware.Auth)
	api.GET("/ping", controller.Ping) // 测试用

	// 前端向后端申请一个包含sessionId的cookie,暂不不支持自定义cookie有效时间，默认半小时
	api.GET("/ask/sid", controller.AskUid)

	/* 前端用于上传文件的接口，
	* 传输文件内容，content:"xxx", 以文本形式传输
	* 使用时带上文件类型，如fileType："application/x-tex"，不设置则下载时无法告知前端文件类型，默认为"text/plain"
	* 使用时最好带cookie，没有就用申请api申请。
	* 其余参数可以不设置，有效期默认半小时后， 最大可访问次数默认30（config文件）
	 */
	api.POST("/file/upload", controller.FileUp) //  接收文件

	/*
	* 前端用于下载文件的接口
	* 需要cookie，url，passwd
	* 使用时带cookie。如果cookie有权限，则直接返回有文件内容的response。没有则返回一个需要密码的状态码
	* 前端跳转密码输入界面获取密码后带上密码再次使用此接口，密码正确则给接口权限，返回内容
	* 若文件没设密码则不带密码也可访问
	* 状态码： 403：密码错误；  410：内容过期；  200：访问成功；  401：请进行身份验证（输密码）
	 */
	api.POST("/file/download", controller.Down)
	api.POST("text/upload", controller.TextUp)
	api.POST("text/download", controller.Down)
}

func ApiAssign() {

}
