package model

import (
	//"fmt"
	"time"
	// "math/rand"

	"github.com/sirupsen/logrus"
	"github.com/spf13/viper"
	"gorm.io/driver/mysql"
	"gorm.io/gorm"
)

var DB *gorm.DB

func Init() {
	ConnectDatabase()
	var err error
	// insert auto-table
	err = DB.AutoMigrate(&Content{})
	if err != nil {
		logrus.Fatal(err)
	}
	err = DB.AutoMigrate(&Users{})
	if err != nil {
		logrus.Fatal(err)
	}
	err = DB.AutoMigrate(&Rel{})
	if err != nil {
		logrus.Fatal(err)
	}
}

func ConnectDatabase() {
	// config
	viper.SetConfigName("config")
	viper.SetConfigType("yaml")
	viper.AddConfigPath("./")
	err := viper.ReadInConfig()
	if err != nil {
		logrus.Panic(err)
	}
	// connect to database
	logInfo := viper.GetStringMapString("mysql")
	sqlInfo := logInfo["user"] + ":" + logInfo["password"] +
		"@(localhost)/" + logInfo["database"] + "?charset=utf8mb4&parseTime=True&loc=Local"
	DB, err = gorm.Open(mysql.Open(sqlInfo), &gorm.Config{})
	if err != nil {
		logrus.Panic(err)
	}
}

// Backcheck content through link
// 通过链接反查内容
func Findlink(_url string) string {
	var p Content
	err := DB.First(&p, "Url1 = ?", _url)
	if err != nil {
		logrus.Error(err)
	}
	return p.S
}

// save text information
// 保存文本和文件信息
func Savetext(_S string, _Time uint, _Passwd string, _Time1 time.Time, _url string, _Filetype string, _Filename string,_Hlight bool) {
	var id1 int64
	DB.Model(&Content{}).Count(&id1)
	id1++
	p := Content{
		ID:       id1,
		S:        _S,
		Time:     _Time,
		Passwd:   _Passwd,
		Date:     time.Now(),
		Time1:    _Time1,
		Time2:    0,
		Url1:     _url,
		Filetype: _Filetype,
		Filename: _Filename,
		Hlight: _Hlight,
	}
	DB.Create(&p)
}

// Check whether the number of visits exceeds the threshold and the time limit
// 检查是否超过总访问次数和截止时间
func Checkt(p Content) bool {
	t := time.Now()
	p.Time2++
	//fmt.Println(p.Time2)
	if p.Time2 > p.Time || t.After(p.Time1) {
		DB.Delete(&p)
		return true
	}
	DB.Model(&Content{}).Where("Url1 = ?", p.Url1).Update("Time2", p.Time2)
	return false
}

// 这个函数那边有可能需要
// 检查sid_url是否超时
//同时也可以查询sid,_url是否关联
func Find(sid string,_url string) bool {
	var s Rel
	err := DB.Where(&Rel{Sid: sid,Url: _url}).First(&s).Error
	if err != nil  {
		return false 
	}
	t := time.Now()
	if t.After(s.Time) {
		DB.Delete(&s)
		return false
	} else {
		return true
	}
}

// 通过url查询文件类型
func Find1(_url string, key string) string {
	var p Content
	DB.First(&p, "Url1 = ?", _url)
	switch key {
	case "content":
		return p.S
	case "fileType":
		return p.Filetype
	case "fileName":
		return p.Filename
	}
	return ""
}

//   通过url查询文件是否高亮
func Find2(_url string) bool {
	var p Content
	DB.First(&p, "Url1 = ?", _url)
	return p.Hlight
}

/*//*随机生成字符串
func randStr(n int) string {
	rand.Seed(time.Now().Unix())
    b := make([]rune, n)
    for i := range b {
        b[i] = letters[rand.Intn(len(letters))]
    }
    return string(b)
}*/

// 新建用户
func Createuser(_User Users) {
	//_User.SessionId=randStr(8)
	DB.Create(&_User)
}

//新建链接
/* 返回值：
   3 表示sid_url已经过期，需要重新分配
   2 表示内容过期
   1 表示密码正确
   0 表示密码不正确
*/
func Createlink(sid string, _passwd string, _url string, _Time1 time.Time) uint {
	var p Content
	DB.First(&p,"Url1 = ?", _url)
	if p.Passwd == _passwd {
		if Checkt(p) {
			//fmt.Println(sid,_passwd,_url,_Time1)
			return 2
		}
		var p1 Rel
		err := DB.Where(&Rel{Sid: sid,Url: _url}).First(&p1).Error
		if err != nil {
			rel1 := Rel{
				Sid:    sid,
				Url:    _url,
				Time:   _Time1,
			}
			DB.Create(&rel1)
		} else {
			p1.Time = _Time1
			DB.Save(&p1)
		}
		return 1
	}
	return 0
}

// 第一次上传
func CreatelinkFirstTime(sid string, _url string, _Time1 time.Time) {
    sid1 := Rel{
		Sid:  sid,
		Url:  _url,
		Time: _Time1,
		}
	DB.Create(&sid1)
}

/*
func Test() {
	fmt.Println(Find("ab","12345"))
}*/
