package controller

import (
	"backend/app/response"
	"backend/model"
	"encoding/json"
	"net/http"
	"time"

	"github.com/labstack/echo/v4"
	"github.com/sirupsen/logrus"
)

func Ping(c echo.Context) error {
	// just test
	return response.SendResponse(c, http.StatusOK, "", "pong!")
}

// 申请一个包含uid的cookie
func AskUid(c echo.Context) error {
	nsid := IdGen(8)
	info := new(Upload)
	cookie := new(http.Cookie)
	err := SetCookie(c, cookie, nsid, info.MaxAge, info.Expiration)
	if err != nil {
		return err
	} else {
		return c.HTML(http.StatusOK, "success")
	}

}

// 成功则返回上传成功，否则报错
// sessionId不直接绑定，通过cookie传
func TextUp(c echo.Context) error {
	info := new(Upload)
	if err := c.Bind(info); err != nil {
		return err
	}
	info.Expiration = timeAssign(info.Expiration) // 默认时间

	if overflow(info.Content, 8*1024*1024) {
		return response.SendResponse(c, http.StatusForbidden, "error:文件上传失败: 文件大小超过8MB.", "")
	}

	// 更新数据库
	_, url := DBupdate(c, info) // 不分配uid
	//return response.SendResponse2(c, http.StatusOK, "文件上传成功", info.TextName, GetTextContentType(info.TextType), url)
	return response.SendResponse(c, http.StatusOK, "文件上传成功", url)
}

func FileUp(c echo.Context) error {
	info := new(Upload)
	if err := c.Bind(info); err != nil {
		return err
	}
	info.Expiration = timeAssign(info.Expiration) // 默认时间

	file, err := c.FormFile("file")
	if err != nil {
		logrus.Println(err)
		return err
	}
	info.Name = file.Filename
	data := new(Msg2)

	info.Content, data.Size, _ = FileRead(file)
	info.MaxView = uint(Settings.MaxDefaultView)

	if data.Size > 8*1024*1024 {
		return response.SendResponse(c, http.StatusForbidden, "error:文件上传失败: 文件大小超过8MB.", "")
	}

	// 更新数据库
	_, data.Url = DBupdate(c, info) // 不分配uid
	data.Name = info.Name
	dataj, err := json.Marshal(data)
	if err != nil {
		logrus.Println(err)
		return err
	}
	//return response.SendResponse2(c, http.StatusOK, "文件上传成功", info.TextName, GetTextContentType(info.TextType), url)
	return response.SendResponse(c, http.StatusOK, "文件上传成功", string(dataj))
}

/*
 * 输入：前端提供的文件链接，
 * 返回：一个可供URL访问的链接（string）
 * cookie.Value 传sessionId
 */
func Down(c echo.Context) error {
	info := new(Download)
	if err := c.Bind(info); err != nil {
		logrus.Println(err)
		return err
	}
	//info.Time = timeAssign(info.Time) // 默认时间为当前半小时后

	cookie, _ := c.Cookie("User")
	cookieMsg := ""
	if cookie == nil {
		// cookieMsg = "没有cookie,已分配.\n"
		cookie = new(http.Cookie)
		SetCookie(c, cookie, IdGen(8), 1800, time.Time{})
	}

	// 鉴权
	stat := Autheticate(cookie, info.Url, info.Passwd, time.Now().Add(1800)) // 包含创建链接Createlink
	// response
	switch stat {

	case 0:
		return response.SendResponse(c, http.StatusForbidden, cookieMsg+"error:密码错误", "") //403
	case 1: // 鉴权通过
		Data := new(Msg)
		Data.Content = model.Find1(info.Url, "content") // 文件内容
		Data.Type = model.Find1(info.Url, "TextType")   // 文件类型
		Data.Type = GetFileContentType(Data.Type)
		Data.Name = model.Find1(info.Url, "TextName")
		dataj, _ := json.Marshal(Data)                                                     // 文件名
		return response.SendResponse(c, http.StatusOK, cookieMsg+"success", string(dataj)) // 返回数据
	case 2:
		return response.SendResponse(c, http.StatusGone, cookieMsg+"error:内容过期", "") //410
	case 3:
		return response.SendResponse(c, http.StatusUnauthorized, cookieMsg+"error:内容过期", "") //401
	case 4:
		return response.SendResponse(c, http.StatusInternalServerError, cookieMsg+"error:Internal Server Error", "") //500
	}
	return nil
}
