package main

import (
	"net/http"

	"github.com/zyz/comment-api/db"

	"github.com/sirupsen/logrus"
)

func main() {
	// 初始化日志
	logrus.SetFormatter(&logrus.JSONFormatter{})
	logrus.Info("启动服务器...")

	// 初始化数据库
	db.InitDB()

	// 注册路由
	http.HandleFunc("/comment/get", getCommentsHandler)
	http.HandleFunc("/comment/add", addCommentHandler)
	http.HandleFunc("/comment/delete", deleteCommentHandler)

	// 启动服务器
	addr := ":8080"
	logrus.WithField("address", addr).Info("服务器启动")
	if err := http.ListenAndServe(addr, nil); err != nil {
		logrus.WithError(err).Fatal("服务器启动失败")
	}
}
