package db

import (
	"github.com/sirupsen/logrus"
	"gorm.io/driver/postgres"
	"gorm.io/gorm"
)

// DB 全局数据库实例
var DB *gorm.DB

// InitDB 初始化 PostgreSQL 数据库
func InitDB() {
	// PostgreSQL 连接字符串
	// 替换为你的实际配置：host、port、user、password、dbname
	dsn := "host=localhost port=5432 user=go_zyz password=zyz757605 dbname=mygo sslmode=disable"
	var err error
	DB, err = gorm.Open(postgres.Open(dsn), &gorm.Config{})
	if err != nil {
		logrus.WithError(err).Fatal("数据库连接失败")
	}

	// 自动迁移，创建/更新 Comment 表
	if err := DB.AutoMigrate(&Comment{}); err != nil {
		logrus.WithError(err).Fatal("数据库迁移失败")
	}

	logrus.Info("PostgreSQL 数据库初始化成功")
}
