// 获取 DOM 元素
const usernameInput = document.getElementById('username');
const commentInput = document.getElementById('comment');
const submitButton = document.getElementById('submit');
const commentsList = document.getElementById('commentsList');
const paginationContainer = document.getElementById('pagination'); // 翻页容器

// 计数器
let count = 0;
let currentPage = 1; // 当前页码
const commentsPerPage = 2; // 每页显示的评论数

// 存储评论数据
let comments = [];

// 监听提交按钮点击事件
submitButton.addEventListener('click', function () {
    usernameInput.value = usernameInput.value.trim();
    commentInput.value = commentInput.value.trim();

    // 验证输入是否为空
    if (usernameInput.value === '' || commentInput.value === '') {
        alert('请填写用户名和评论内容！');
        return;
    }

    console.log('提交评论:', usernameInput.value, commentInput.value);
    count++; // 增加计数器
    console.log('当前评论数量:', count);

    // 将评论添加到评论数组中
    const newComment = {
        username: usernameInput.value,
        content: commentInput.value
    };
    comments.push(newComment);

    // 清空输入框
    usernameInput.value = '';
    commentInput.value = '';

    // 更新评论显示
    displayComments();
    updatePagination();
});

// 显示评论
function displayComments() {
    // 清空评论列表
    commentsList.innerHTML = '';

    // 计算当前页显示的评论范围
    const startIndex = (currentPage - 1) * commentsPerPage;
    const endIndex = Math.min(startIndex + commentsPerPage, comments.length);

    // 根据当前页显示评论
    for (let i = startIndex; i < endIndex; i++) {
        const comment = comments[i];
        
        const li = document.createElement('li');
        li.className = 'comment-item'; // 给评论项添加类名（可选，方便整体样式）

        // 创建用户名元素（span）
        const usernameSpan = document.createElement('span');
        usernameSpan.className = 'comment__username'; // 用户名类名（用于CSS）
        usernameSpan.textContent = comment.username;

        // 创建评论内容元素（span）
        const contentSpan = document.createElement('span');
        contentSpan.className = 'comment__content'; // 评论内容类名（用于CSS）
        contentSpan.textContent = comment.content;

        // 创建删除按钮
        const deleteButton = document.createElement('button');
        deleteButton.className = 'commonButton'; // 删除按钮类名（用于CSS）

        // 添加删除按钮的点击事件
        deleteButton.textContent = '删除'; // 设置删除按钮文本
        deleteButton.addEventListener('click', function () {
            // 删除当前评论
            comments.splice(i, 1); // 从评论数组中移除该评论
            displayComments(); // 重新渲染评论
            updatePagination(); // 更新分页
        });

        // 将元素组装到li中（顺序：用户名 → 分隔符 → 内容）
        li.appendChild(usernameSpan);
        li.appendChild(document.createElement('br')); // 添加换行符
        li.appendChild(contentSpan);
        li.appendChild(deleteButton); // 添加删除按钮

        commentsList.appendChild(li); // 将li添加到评论列表中
    }
}

// 更新分页
function updatePagination() {
    // 清空分页容器
    paginationContainer.innerHTML = '';

    const totalPages = Math.ceil(comments.length / commentsPerPage); // 计算总页数

    // 生成翻页按钮
    for (let i = 1; i <= totalPages; i++) {
        const pageButton = document.createElement('button');
        pageButton.className = 'pagination-button'; // 翻页按钮类名（用于CSS）
        pageButton.textContent = i;
        pageButton.addEventListener('click', function () {
            currentPage = i; // 设置当前页码
            displayComments(); // 更新评论显示
        });
        paginationContainer.appendChild(pageButton);
    }
}
