// 获取 DOM 元素
const usernameInput = $('#username');
const commentInput = $('#comment');
const submitButton = $('#submit');
const commentsList = $('#commentsList');
const paginationContainer = $('#pagination');

let currentPage = 1;
const commentsPerPage = 2;
let totalComments = 0;

// 初始化加载第一页评论
loadComments(currentPage);

// 添加评论
submitButton.on('click', function () {
    const name = usernameInput.val().trim();
    const content = commentInput.val().trim();

    if (!name || !content) {
        alert('请填写用户名和评论内容！');
        return;
    }

    $.ajax({
        url: '/comment/add',
        method: 'POST',
        contentType: 'application/json',
        data: JSON.stringify({ name, content }),
        success: function (res) {
            if (res.code === 0) {
                alert('评论成功！');
                usernameInput.val('');
                commentInput.val('');
                loadComments(currentPage); // 重新加载当前页
            } else {
                alert('添加失败：' + res.msg);
            }
        },
        error: function () {
            alert('请求失败，请稍后重试');
        }
    });
});

// 加载评论
function loadComments(page) {
    $.get('/comment/get', { page, size: commentsPerPage }, function (res) {
        if (res.code === 0) {
            totalComments = res.data.total;
            displayComments(res.data.comments);
            updatePagination();
        } else {
            alert('加载评论失败：' + res.msg);
        }
    });
}

// 渲染评论
function displayComments(comments) {
    commentsList.empty();

    comments.forEach(comment => {
        const li = $('<li>').addClass('comment-item');

        const usernameSpan = $('<span>').addClass('comment__username').text(comment.name);
        const contentSpan = $('<span>').addClass('comment__content').text(comment.content);
        const deleteButton = $('<button>').addClass('commonButton').text('删除');

        deleteButton.on('click', function () {
            if (!confirm('确定删除这条评论吗？')) return;

            $.post('/comment/delete', { id: comment.id }, function (res) {
                if (res.code === 0) {
                    alert('删除成功');
                    loadComments(currentPage);
                } else {
                    alert('删除失败：' + res.msg);
                }
            });
        });

        li.append(usernameSpan).append('<br>').append(contentSpan).append(deleteButton);
        commentsList.append(li);
    });
}

// 渲染分页
function updatePagination() {
    paginationContainer.empty();
    const totalPages = Math.ceil(totalComments / commentsPerPage);

    for (let i = 1; i <= totalPages; i++) {
        const pageButton = $('<button>').addClass('pagination-button').text(i);

        if (i === currentPage) {
            pageButton.prop('disabled', true);
        }

        pageButton.on('click', function () {
            currentPage = i;
            loadComments(currentPage);
        });

        paginationContainer.append(pageButton);
    }
}
