package db

import (
	"github.com/sirupsen/logrus"
	"gorm.io/driver/postgres"
	"gorm.io/gorm"
)

// DB 全局数据库实例（保持不变）
var DB *gorm.DB

// InitDB 初始化 PostgreSQL 数据库（修改：返回error类型）
func InitDB() error { // 关键：添加error返回值
	// PostgreSQL 连接字符串（替换为你的实际配置）
	dsn := "host=localhost port=5432 user=go_zyz password=zyz757605 dbname=mygo sslmode=disable client_encoding=utf8"
	var err error

	// 连接数据库
	DB, err = gorm.Open(postgres.Open(dsn), &gorm.Config{})
	if err != nil {
		logrus.WithError(err).Error("数据库连接失败") // 改为Error（不退出）
		return err                             // 返回错误
	}

	// 自动迁移表（创建/更新Comment表）
	if err := DB.AutoMigrate(&Comment{}); err != nil {
		logrus.WithError(err).Error("数据库迁移失败") // 改为Error（不退出）
		return err                             // 返回错误
	}

	logrus.Info("PostgreSQL 数据库初始化成功")
	return nil // 成功返回nil
}
