import prisma from "@/lib/prisma";
import bcrypt from "bcrypt";

export async function POST(request: Request) {
  try {
    const { username, password } = await request.json();
    
    if (!username || !password) {
      return new Response("用户名和密码不能为空", { status: 400 });
    }
    
    const existingUser = await prisma.user.findUnique({
      where: { username }
    });
    
    if (existingUser) {
      return new Response("用户名已存在", { status: 400 });
    }
    
    const hashedPassword = await bcrypt.hash(password, 10);
    
    const newUser = await prisma.user.create({
      data: {
        username,
        password: hashedPassword,
        email: `${username}@example.com`, // 添加 email 字段
      }
    });
    
    return new Response(JSON.stringify({ 
      id: newUser.id,
      username: newUser.username
    }), { status: 201 });
    
  } catch (error) {
    console.error("注册失败:", error);
    return new Response("服务器错误", { status: 500 });
  }
}