import prisma from "@/lib/prisma";

export async function GET() {
  try {
    const rooms = await prisma.room.findMany();
    return Response.json(rooms.map(room => ({
      id: room.id.toString(),
      name: room.name
    })));
  } catch (error) {
    console.error("获取房间列表失败:", error);
    return new Response("服务器错误", { status: 500 });
  }
}

export async function POST(request: Request) {
  try {
    const { name } = await request.json();
    
    if (!name || !name.trim()) {
      return new Response("房间名称不能为空", { status: 400 });
    }
    
    const newRoom = await prisma.room.create({
      data: { name: name.trim() }
    });
    
    return Response.json({
      id: newRoom.id.toString(),
      name: newRoom.name
    });
  } catch (error) {
    console.error("创建房间失败:", error);
    return new Response("服务器错误", { status: 500 });
  }
}