// 聊天相关类型定义 - 与现有接口保持一致

// 用户角色枚举
export enum UserRole {
  ADMIN = 'ADMIN',
  USER = 'USER'
}

// 用户状态枚举
export enum UserStatus {
  ONLINE = 'ONLINE',
  OFFLINE = 'OFFLINE',
  AWAY = 'AWAY'
}

// 用户信息
export interface User {
  id: string;
  username: string;
  email: string;
  nickname: string;
  avatar?: string;
  status: UserStatus;
  role: UserRole;
  createdAt: Date;
  updatedAt: Date;
}

// 消息类型
export interface Message {
  messageId: number; // 消息 id
  roomId: number; // 房间 id
  sender: string; // 发送人的 username
  content: string; // 消息内容
  time: number; // 消息发送时间戳
}

// 房间信息
export interface Room {
  roomId: number; // 房间 id
  roomName: string; // 房间名称
  creator: string; // 创建者
  createdAt: Date;
  updatedAt: Date;
}

// 房间预览信息
export interface RoomPreviewInfo {
  roomId: number;
  roomName: string;
  lastMessage: Message | null;
}

// API 接口参数类型
export interface RoomAddArgs {
  user: string;
  roomName: string;
}

export interface RoomAddRes {
  roomId: number;
}

export interface RoomListRes {
  rooms: RoomPreviewInfo[];
}

export interface RoomDeleteArgs {
  user: string;
  roomId: number;
}

export interface MessageAddArgs {
  roomId: number;
  content: string;
  sender: string;
}

export interface RoomMessageListArgs {
  roomId: number;
}

export interface RoomMessageListRes {
  messages: Message[];
}

export interface RoomMessageGetUpdateArgs {
  roomId: number;
  sinceMessageId: number;
}

export interface RoomMessageGetUpdateRes {
  messages: Message[];
}
