// 用户认证相关类型定义

// 用户基础信息
export interface User {
  id: string;
  username: string;
  email: string;
  nickname: string;
  avatar?: string;
  status: UserStatus;
  createdAt: Date;
  updatedAt: Date;
}

// 用户状态枚举
export enum UserStatus {
  ONLINE = 'ONLINE',
  OFFLINE = 'OFFLINE',
  AWAY = 'AWAY'
}

// 用户注册请求
export interface RegisterRequest {
  username: string;
  email: string;
  password: string;
  nickname: string;
}

// 用户登录请求
export interface LoginRequest {
  username: string;
  password: string;
}

// 认证响应
export interface AuthResponse {
  user: User;
  accessToken: string;
  refreshToken: string;
}

// JWT 载荷
export interface JWTPayload {
  userId: string;
  username: string;
  email: string;
  iat: number;
  exp: number;
}

// 刷新令牌
export interface RefreshToken {
  token: string;
  userId: string;
  expiresAt: Date;
}

// API 响应格式
export interface ApiResponse<T = unknown> {
  message: string;
  code: number;
  data: T | null;
}

// 错误响应
export interface ErrorResponse {
  message: string;
  code: number;
  error: string;
  details?: Record<string, unknown>;
}
