const API_BASE_URL = process.env.NEXT_PUBLIC_API_URL || 'http://localhost:3000';

export const fetcher = async (path: string, args?: RequestInit) => {
  const url = `${API_BASE_URL}${path}`;
  
  try {
    const res = await fetch(url, {
      ...args,
      headers: {
        'Content-Type': 'application/json',
        ...args?.headers,
      },
    });

    if (!res.ok && res.status !== 201 && res.status !== 409 && res.status !== 401) {
      const error = new Error(`HTTP error! status: ${res.status}`);
      (error as Error & { status?: number }).status = res.status;
      throw error;
    }

    const json = await res.json();
    
    if (json.code !== 0) {
      const error = new Error(json.message || 'API返回错误');
      (error as Error & { info?: unknown; code?: number }).info = json.data;
      (error as Error & { info?: unknown; code?: number }).code = json.code;
      throw error;
    }

    return json.data;
  } catch (error: unknown) {
    // 如果是网络错误
    if (error instanceof Error && error.name === 'TypeError' && error.message.includes('fetch')) {
      throw new Error('网络连接失败，请检查网络连接');
    }
    
    // 如果是API错误
    if (error instanceof Error && (error as Error & { code?: number }).code !== undefined) {
      throw error;
    }
    
    // 其他错误
    if (error instanceof Error) {
      throw new Error(error.message || '请求失败');
    }
    
    throw new Error('未知错误');
  }
};
