#!/bin/bash

# 管理员账户设置脚本
# 用于快速设置内置管理员账户和测试数据

echo "🚀 开始设置管理员账户和测试数据..."

# 检查是否在正确的目录
if [ ! -f "package.json" ]; then
    echo "❌ 请在项目根目录运行此脚本"
    exit 1
fi

# 安装依赖
echo "📦 安装依赖..."
pnpm install

# 生成 Prisma 客户端
echo "🔧 生成 Prisma 客户端..."
pnpm db:generate

# 重置数据库并运行迁移
echo "🗄️ 重置数据库..."
pnpm db:reset --force

# 运行种子数据
echo "🌱 创建种子数据..."
pnpm db:seed

# 运行管理员功能测试
echo "🧪 测试管理员功能..."
pnpm tsx scripts/test-admin.ts

echo ""
echo "✅ 设置完成！"
echo ""
echo "📋 测试账户信息:"
echo "┌─────────────┬─────────────┬─────────────┬─────────────┐"
echo "│   用户名    │    密码     │    昵称     │    角色     │"
echo "├─────────────┼─────────────┼─────────────┼─────────────┤"
echo "│   admin     │  admin123   │ 系统管理员  │   管理员    │"
echo "│   alice     │  alice123   │   爱丽丝    │   普通用户  │"
echo "│    bob      │   bob123    │    鲍勃     │   普通用户  │"
echo "│  charlie    │ charlie123  │    查理     │   普通用户  │"
echo "│   diana     │  diana123   │   黛安娜    │   普通用户  │"
echo "│    eve      │   eve123    │    夏娃     │   普通用户  │"
echo "└─────────────┴─────────────┴─────────────┴─────────────┘"
echo ""
echo "🏠 测试房间:"
echo "• 欢迎大厅 (管理员创建)"
echo "• 技术讨论 (爱丽丝创建)"
echo "• 闲聊天地 (鲍勃创建)"
echo "• 游戏交流 (查理创建)"
echo ""
echo "🚀 启动开发服务器:"
echo "pnpm dev"
echo ""
echo "🌐 访问地址:"
echo "• 主应用: http://localhost:3000"
echo "• 管理员页面: http://localhost:3000/admin"
echo "• 数据库管理: pnpm db:studio"
echo ""
echo "💡 使用说明:"
echo "1. 使用 admin/admin123 登录系统"
echo "2. 管理员可以删除任何房间和消息"
echo "3. 普通用户只能管理自己创建的内容"
echo "4. 访问 /admin 页面查看用户管理界面"
