-- 聊天室数据库初始化脚本

-- 创建数据库（如果不存在）
-- 注意：这个脚本在容器启动时自动执行

-- 设置时区
SET timezone = 'UTC';

-- 创建扩展（如果需要）
CREATE EXTENSION IF NOT EXISTS "uuid-ossp";

-- 创建自定义类型（如果需要）
-- 这些类型在 Prisma schema 中定义，这里只是示例

-- 设置默认权限
ALTER DEFAULT PRIVILEGES IN SCHEMA public GRANT ALL ON TABLES TO postgres;
ALTER DEFAULT PRIVILEGES IN SCHEMA public GRANT ALL ON SEQUENCES TO postgres;

-- 创建索引（如果需要）
-- 这些索引在 Prisma schema 中定义，这里只是示例

-- 插入初始数据（如果需要）
-- 例如：默认用户、系统配置等

-- 设置搜索路径
SET search_path TO public;

-- 完成初始化
SELECT 'Database initialization completed successfully!' as status;
