export interface Message {
  messageId: number; // 消息 id
  roomId: number; // 房间 id
  sender: string; // 发送人的 username
  content: string; // 消息内容
  time: number; // 消息发送时间戳
}

export interface RoomPreviewInfo {
  roomId: number;
  roomName: string;
  lastMessage: Message | null;
}

// API 接口参数类型
export interface RoomAddArgs {
  user: string;
  roomName: string;
}

export interface RoomAddRes {
  roomId: number;
}

export interface RoomListRes {
  rooms: RoomPreviewInfo[];
}

export interface RoomDeleteArgs {
  user: string;
  roomId: number;
}

export interface MessageAddArgs {
  roomId: number;
  content: string;
  sender: string;
}

export interface RoomMessageListArgs {
  roomId: number;
}

export interface RoomMessageListRes {
  messages: Message[];
}

export interface RoomMessageGetUpdateArgs {
  roomId: number;
  sinceMessageId: number;
}

export interface RoomMessageGetUpdateRes {
  messages: Message[];
}

// 统一返回模式
export interface ApiResponse<T> {
  message: string;
  code: number;
  data: T | null;
}
