'use client';

import React from 'react';
import { Message } from '../types';
import styles from './MessageItem.module.css';

interface MessageItemProps {
  message: Message;
  isOwnMessage: boolean;
}

export default function MessageItem({ message, isOwnMessage }: MessageItemProps) {
  const messageDate = new Date(message.time).toLocaleTimeString();

  return (
    <div className={`${styles.messageRow} ${isOwnMessage ? styles.ownMessage : ''}`}>
      <div className={styles.messageBubble}>
        {!isOwnMessage && <div className={styles.senderName}>{message.sender}</div>}
        <div className={styles.messageContent}>{message.content}</div>
        <div className={styles.messageTime}>{messageDate}</div>
      </div>
    </div>
  );
}
