<<<<<<< HEAD
# 聊天室项目

一个基于 Next.js 的实时聊天室应用，支持多房间聊天、用户认证和实时消息推送。

## 🚀 快速开始

### 环境要求
- Node.js 18+
- pnpm 8+
- PostgreSQL 15+ (生产环境)
- SQLite (开发环境)

### 安装和运行

```bash
# 克隆项目
git clone <repository-url>
cd chatroom

# 安装依赖
cd fullstack
pnpm install

# 设置环境变量
cp .env.example .env
# 编辑 .env 文件，配置数据库连接

# 初始化数据库
npx prisma db push
pnpm db:seed

# 启动开发服务器
pnpm dev
```

访问 http://localhost:3000 查看应用。

## 📁 项目结构

```
chatroom/
├── fullstack/                 # 主应用目录
│   ├── src/
│   │   ├── app/              # Next.js App Router
│   │   │   ├── api/          # API 路由
│   │   │   ├── admin/        # 管理员页面
│   │   │   └── page.tsx      # 主页面
│   │   ├── components/       # React 组件
│   │   └── lib/              # 工具函数
│   ├── prisma/               # 数据库模式
│   ├── public/               # 静态资源
│   ├── docker-compose.yml    # Docker 配置
│   ├── Dockerfile            # 生产环境镜像
│   └── package.json          # 项目配置
├── .gitignore                # Git 忽略文件
└── README.md                 # 项目说明
```

## 🛠️ 技术栈

### 前端
- **Next.js 14** - React 框架
- **TypeScript** - 类型安全
- **SWR** - 数据获取和缓存
- **Ant Design** - UI 组件库

### 后端
- **Next.js API Routes** - 服务端 API
- **Prisma ORM** - 数据库操作
- **JWT** - 用户认证
- **Server-Sent Events** - 实时通信

### 数据库
- **PostgreSQL** - 生产环境
- **SQLite** - 开发环境

### 部署
- **Docker** - 容器化部署
- **Docker Compose** - 多服务编排

## 🔧 主要功能

- ✅ 用户注册和登录
- ✅ 多房间聊天
- ✅ 实时消息推送
- ✅ 管理员功能
- ✅ 响应式设计
- ✅ Docker 部署支持

## 📊 项目架构

```mermaid
graph TB
    A[客户端浏览器] -->|HTTP/SSE| B[Next.js 应用]
    B --> C[API 路由]
    C --> D[Prisma ORM]
    D --> E[(数据库)]
    C --> F[SSE 发布器]
    F --> G[房间事件总线]
    G --> H[实时消息流]
```

## 🚀 部署

### Docker 部署

```bash
# 开发环境
docker-compose up frontend

# 生产环境
docker-compose --env-file .env.docker --profile production up -d
```

### 环境变量

创建 `.env` 文件：

```bash
# 数据库
DATABASE_URL="postgresql://user:password@localhost:5432/chatroom"

# JWT 密钥
JWT_SECRET="your-secret-key"
JWT_REFRESH_SECRET="your-refresh-secret"

# 管理员账户
ADMIN_USERNAME="admin"
ADMIN_PASSWORD="admin123"
```

## 🧪 测试

### API 测试

```bash
# 健康检查
curl http://localhost:3000/api/health

# 用户登录
curl -X POST http://localhost:3000/api/auth/login \
  -H "Content-Type: application/json" \
  -d '{"username":"admin","password":"admin123"}'
```

### 内置测试用户

- **管理员**: admin / admin123
- **普通用户**: alice / alice123, bob / bob123

## 📝 开发指南

### 代码规范
- 使用 TypeScript 严格模式
- 遵循 ESLint 和 Prettier 配置
- 提交信息使用语义化格式

### 分支策略
- `main` - 主分支
- `develop` - 开发分支
- `feature/*` - 功能分支

## 🤝 贡献

1. Fork 项目
2. 创建功能分支 (`git checkout -b feature/AmazingFeature`)
3. 提交更改 (`git commit -m 'Add some AmazingFeature'`)
4. 推送到分支 (`git push origin feature/AmazingFeature`)
5. 创建 Pull Request

## 📄 许可证

本项目采用 MIT 许可证 - 查看 [LICENSE](LICENSE) 文件了解详情。

## 📞 联系方式

如有问题或建议，请通过以下方式联系：

- 创建 Issue
- 发送邮件至 [your-email@example.com]

---

> 💡 **提示**: 这是一个学习项目，展示了现代全栈 Web 开发的最佳实践。适合作为学习 Next.js、实时通信和容器化部署的参考。
=======
# chatroom



## Getting started

To make it easy for you to get started with GitLab, here's a list of recommended next steps.

Already a pro? Just edit this README.md and make it your own. Want to make it easy? [Use the template at the bottom](#editing-this-readme)!

## Add your files

- [ ] [Create](https://docs.gitlab.com/ee/user/project/repository/web_editor.html#create-a-file) or [upload](https://docs.gitlab.com/ee/user/project/repository/web_editor.html#upload-a-file) files
- [ ] [Add files using the command line](https://docs.gitlab.com/ee/gitlab-basics/add-file.html#add-a-file-using-the-command-line) or push an existing Git repository with the following command:

```
cd existing_repo
git remote add origin http://xlab.zju.edu.cn/git/XuZhenrong/chatroom.git
git branch -M main
git push -uf origin main
```

## Integrate with your tools

- [ ] [Set up project integrations](http://xlab.zju.edu.cn/git/XuZhenrong/chatroom/-/settings/integrations)

## Collaborate with your team

- [ ] [Invite team members and collaborators](https://docs.gitlab.com/ee/user/project/members/)
- [ ] [Create a new merge request](https://docs.gitlab.com/ee/user/project/merge_requests/creating_merge_requests.html)
- [ ] [Automatically close issues from merge requests](https://docs.gitlab.com/ee/user/project/issues/managing_issues.html#closing-issues-automatically)
- [ ] [Enable merge request approvals](https://docs.gitlab.com/ee/user/project/merge_requests/approvals/)
- [ ] [Automatically merge when pipeline succeeds](https://docs.gitlab.com/ee/user/project/merge_requests/merge_when_pipeline_succeeds.html)

## Test and Deploy

Use the built-in continuous integration in GitLab.

- [ ] [Get started with GitLab CI/CD](https://docs.gitlab.com/ee/ci/quick_start/index.html)
- [ ] [Analyze your code for known vulnerabilities with Static Application Security Testing(SAST)](https://docs.gitlab.com/ee/user/application_security/sast/)
- [ ] [Deploy to Kubernetes, Amazon EC2, or Amazon ECS using Auto Deploy](https://docs.gitlab.com/ee/topics/autodevops/requirements.html)
- [ ] [Use pull-based deployments for improved Kubernetes management](https://docs.gitlab.com/ee/user/clusters/agent/)
- [ ] [Set up protected environments](https://docs.gitlab.com/ee/ci/environments/protected_environments.html)

***

# Editing this README

When you're ready to make this README your own, just edit this file and use the handy template below (or feel free to structure it however you want - this is just a starting point!). Thank you to [makeareadme.com](https://www.makeareadme.com/) for this template.

## Suggestions for a good README
Every project is different, so consider which of these sections apply to yours. The sections used in the template are suggestions for most open source projects. Also keep in mind that while a README can be too long and detailed, too long is better than too short. If you think your README is too long, consider utilizing another form of documentation rather than cutting out information.

## Name
Choose a self-explaining name for your project.

## Description
Let people know what your project can do specifically. Provide context and add a link to any reference visitors might be unfamiliar with. A list of Features or a Background subsection can also be added here. If there are alternatives to your project, this is a good place to list differentiating factors.

## Badges
On some READMEs, you may see small images that convey metadata, such as whether or not all the tests are passing for the project. You can use Shields to add some to your README. Many services also have instructions for adding a badge.

## Visuals
Depending on what you are making, it can be a good idea to include screenshots or even a video (you'll frequently see GIFs rather than actual videos). Tools like ttygif can help, but check out Asciinema for a more sophisticated method.

## Installation
Within a particular ecosystem, there may be a common way of installing things, such as using Yarn, NuGet, or Homebrew. However, consider the possibility that whoever is reading your README is a novice and would like more guidance. Listing specific steps helps remove ambiguity and gets people to using your project as quickly as possible. If it only runs in a specific context like a particular programming language version or operating system or has dependencies that have to be installed manually, also add a Requirements subsection.

## Usage
Use examples liberally, and show the expected output if you can. It's helpful to have inline the smallest example of usage that you can demonstrate, while providing links to more sophisticated examples if they are too long to reasonably include in the README.

## Support
Tell people where they can go to for help. It can be any combination of an issue tracker, a chat room, an email address, etc.

## Roadmap
If you have ideas for releases in the future, it is a good idea to list them in the README.

## Contributing
State if you are open to contributions and what your requirements are for accepting them.

For people who want to make changes to your project, it's helpful to have some documentation on how to get started. Perhaps there is a script that they should run or some environment variables that they need to set. Make these steps explicit. These instructions could also be useful to your future self.

You can also document commands to lint the code or run tests. These steps help to ensure high code quality and reduce the likelihood that the changes inadvertently break something. Having instructions for running tests is especially helpful if it requires external setup, such as starting a Selenium server for testing in a browser.

## Authors and acknowledgment
Show your appreciation to those who have contributed to the project.

## License
For open source projects, say how it is licensed.

## Project status
If you have run out of energy or time for your project, put a note at the top of the README saying that development has slowed down or stopped completely. Someone may choose to fork your project or volunteer to step in as a maintainer or owner, allowing your project to keep going. You can also make an explicit request for maintainers.
>>>>>>> dacd55393d9a1a6d828d3d94b8313044d1ed1794
