# 聊天室前端应用

这是一个基于 Next.js 和 Ant Design 构建的实时聊天室前端应用。

## 功能特性

- 🏠 **用户昵称设置** - 进入应用前设置个人昵称
- 🏘️ **房间管理** - 创建、删除聊天房间
- 💬 **实时聊天** - 支持实时消息发送和接收
- 📱 **响应式设计** - 适配桌面和移动设备
- 🎨 **现代化UI** - 基于 Ant Design 的美观界面
- 🔄 **自动轮询** - 每秒自动更新消息和房间列表
- 💾 **状态持久化** - 记住用户昵称和最后进入的房间

## 技术栈

- **框架**: Next.js 15.5.2 (App Router)
- **语言**: TypeScript
- **UI组件库**: Ant Design 5.27.1
- **状态管理**: React Hooks
- **数据获取**: SWR 2.3.6
- **样式**: CSS Modules
- **图标**: Ant Design Icons + React Icons

## 项目结构

```
src/
├── app/                    # Next.js App Router 页面
│   ├── page.tsx          # 首页 (昵称设置)
│   ├── chat/
│   │   └── page.tsx      # 聊天室页面
│   ├── layout.tsx        # 根布局
│   └── globals.css       # 全局样式
├── components/            # React 组件
│   ├── ChatWindow.tsx    # 聊天窗口组件
│   ├── MessageInput.tsx  # 消息输入组件
│   ├── MessageItem.tsx   # 消息项组件
│   └── RoomList.tsx      # 房间列表组件
├── lib/                   # 工具库
│   ├── AntdRegistry.tsx  # Ant Design 配置
│   └── fetcher.ts        # API 请求工具
└── types/                 # TypeScript 类型定义
    └── index.ts          # 所有类型定义
```

## 快速开始

### 安装依赖

```bash
pnpm install
```

### 开发模式

```bash
pnpm dev
```

应用将在 [http://localhost:3000](http://localhost:3000) 启动。

### 构建生产版本

```bash
pnpm build
pnpm start
```

## 使用说明

### 1. 设置昵称
- 首次访问应用时，需要设置个人昵称
- 昵称长度限制：2-20个字符
- 设置完成后会自动跳转到聊天室

### 2. 聊天室功能
- **左侧房间列表**: 显示所有可用的聊天房间
- **创建房间**: 点击 "+" 按钮创建新房间
- **删除房间**: 点击房间右侧的删除按钮
- **选择房间**: 点击房间进入聊天

### 3. 聊天功能
- **发送消息**: 在底部输入框输入消息内容
- **快捷键**: Enter 发送，Shift + Enter 换行
- **实时更新**: 消息会自动更新，无需刷新页面

## API 接口

应用使用以下后端接口：

- `GET /api/room/list` - 获取房间列表
- `POST /api/room/add` - 创建新房间
- `POST /api/room/delete` - 删除房间
- `GET /api/room/message/list` - 获取房间消息
- `POST /api/message/add` - 发送消息

## 开发特性

### 类型安全
- 完整的 TypeScript 类型定义
- 基于接口文档的严格类型检查
- 自动补全和错误提示

### 状态管理
- 使用 React Hooks 管理组件状态
- SWR 处理数据获取和缓存
- 乐观更新提升用户体验

### 样式系统
- CSS Modules 避免样式冲突
- 响应式设计适配各种设备
- 自定义滚动条和动画效果

## 部署

### 环境要求
- Node.js 18+ 
- pnpm 8+

### 部署步骤
1. 构建项目: `pnpm build`
2. 启动服务: `pnpm start`
3. 配置环境变量 (如需要)

## 贡献指南

1. Fork 项目
2. 创建功能分支
3. 提交更改
4. 推送到分支
5. 创建 Pull Request

## 许可证

MIT License

## 联系方式

如有问题或建议，请通过以下方式联系：
- 提交 Issue
- 发送邮件
- 参与讨论
