# 聊天室全栈项目

基于 Next.js + TypeScript + Prisma 构建的现代化聊天室应用，支持实时通信、用户认证、房间管理等功能。

## 🚀 快速开始

### 环境要求
- Node.js 18+
- pnpm 8+
- Docker (可选，用于容器化部署)

### 本地开发

#### 1. 安装依赖
```bash
pnpm install
```

#### 2. 数据库设置
```bash
# 生成 Prisma 客户端
npx prisma generate

# 创建数据库 (SQLite)
npx prisma db push
```

#### 3. 启动开发服务器
```bash
pnpm dev
```

访问 [http://localhost:3000](http://localhost:3000) 查看应用。

### Docker 部署

#### 开发模式 (SQLite)
```bash
# 启动开发容器
docker compose up -d frontend

# 访问应用
open http://localhost:3001
```

#### 生产模式 (PostgreSQL)
```bash
# 配置环境变量
cp .env.example .env
# 编辑 .env 文件，设置数据库密码等

# 启动生产服务
docker compose --profile production up -d database frontend_prod
```

### 内置管理员账户
```bash
# 创建管理员账户 (需要设置环境变量)
curl -X POST http://localhost:3000/api/auth/seed-admin
```

## 🏗️ 技术栈

- **前端**: Next.js 15.5.2 + TypeScript + Ant Design
- **后端**: Next.js API Routes
- **数据库**: SQLite (开发) / PostgreSQL (生产)
- **ORM**: Prisma
- **状态管理**: SWR
- **部署**: Docker + docker-compose

## 📁 项目结构

```
src/
├── app/                    # Next.js App Router
│   ├── api/               # API 路由
│   │   ├── auth/          # 认证相关API
│   │   ├── room/          # 房间相关API
│   │   └── message/       # 消息相关API
│   ├── chat/              # 聊天页面
│   └── page.tsx           # 首页
├── components/             # React 组件
├── lib/                    # 工具库
└── types/                  # TypeScript 类型
```

## 🔧 主要功能

### 用户认证
- ✅ 用户注册/登录 (JWT + bcrypt)
- ✅ 权限控制 (游客/用户/管理员)
- ✅ 字段级错误提示
- ✅ 内置管理员账户

### 房间管理
- ✅ 房间创建/删除
- ✅ 房间列表显示
- ✅ 权限控制 (创建者/管理员可删除)
- ✅ 房间信息展示

### 实时通信
- ✅ 消息发送/接收
- ✅ Server-Sent Events (SSE) 实时推送
- ✅ 消息历史记录
- ✅ 自动滚动到底部

### 界面设计
- ✅ 响应式界面设计
- ✅ Ant Design 组件库
- ✅ 用户头像和昵称显示
- ✅ 消息气泡样式

## 🐳 Docker 部署

```bash
# 开发模式（使用 SQLite、本地热更新）
docker compose up -d frontend

# 生产模式（使用 PostgreSQL）
docker compose --profile production up -d database frontend_prod

# 查看日志
docker compose logs -f
```

说明：
- 开发环境默认使用 SQLite（`prisma/dev.db`）；生产建议切换 PostgreSQL，并设置 `DATABASE_URL`。
- 前端/后端合一（Next.js App Router），容器内仅需暴露 3000 端口。

首次运行建议执行：
```bash
# 进入容器后生成 Prisma 客户端并推送 schema（生产容器构建阶段已执行）
docker compose exec frontend pnpm prisma generate
docker compose exec frontend npx prisma db push
```

## 🔔 实时通信（SSE）

### 服务端事件流
- 事件流路由：`GET /api/room/message/stream?roomId=<number>`
- 发送消息后服务端会推送事件到对应房间
- 前端自动订阅当前房间事件流

### 本地快速验证
```bash
# 1) 打开事件流
open "http://localhost:3000/api/room/message/stream?roomId=15"

# 2) 发送一条消息
curl -X POST http://localhost:3000/api/message/add \
  -H 'Content-Type: application/json' \
  -d '{"roomId":15,"sender":"test","content":"sse ping"}' | cat
```
预期：事件流页面应即时出现 `data: { ... }` 推送。

## 🎯 演示指南

### 功能演示流程
1. **用户注册/登录**
   - 访问注册页面，创建新用户
   - 或使用内置管理员账户登录

2. **房间管理**
   - 创建新房间
   - 查看房间列表
   - 测试房间删除权限

3. **实时聊天**
   - 进入房间发送消息
   - 多窗口测试实时推送
   - 验证消息历史记录

4. **权限控制**
   - 测试游客/用户/管理员不同权限
   - 验证房间删除权限

### API 测试
```bash
# 健康检查
curl http://localhost:3000/api/health

# 房间列表
curl http://localhost:3000/api/room/list

# 创建管理员账户
curl -X POST http://localhost:3000/api/auth/seed-admin
```

## 📝 开发规范

- 使用 TypeScript 进行类型安全开发
- 遵循 Next.js App Router 最佳实践
- 使用 Prisma 进行数据库操作
- 采用 SWR 进行数据获取和缓存
- 保持代码简洁和模块化

## 🤝 贡献指南

1. Fork 项目
2. 创建功能分支 (`git checkout -b feature/AmazingFeature`)
3. 提交更改 (`git commit -m 'Add some AmazingFeature'`)
4. 推送到分支 (`git push origin feature/AmazingFeature`)
5. 打开 Pull Request

## 📄 许可证

本项目采用 MIT 许可证 - 查看 [LICENSE](LICENSE) 文件了解详情。
