'use client';

import React, { useState, useEffect } from 'react';
import { Layout } from 'antd';
import RoomList from '../../components/RoomList';
import ChatWindow from '../../components/ChatWindow';
import styles from './page.module.css';

const { Sider, Content } = Layout;

export default function ChatPage() {
  const [currentRoomId, setCurrentRoomId] = useState<number | null>(null);
  const [nickname, setNickname] = useState<string | null>(null);
  const [isClient, setIsClient] = useState(false);

  // 客户端检测
  useEffect(() => {
    setIsClient(true);
  }, []);

  // 获取昵称
  useEffect(() => {
    if (isClient) {
      const storedNickname = localStorage.getItem('nickname');
      if (storedNickname) {
        setNickname(storedNickname);
      } else {
        // 如果没有昵称，重定向到首页
        window.location.href = '/';
        return;
      }
    }
  }, [isClient]);

  // 尝试恢复上次进入的房间
  useEffect(() => {
    if (isClient) {
      const lastRoomId = localStorage.getItem('lastRoomId');
      if (lastRoomId) {
        setCurrentRoomId(parseInt(lastRoomId));
      }
    }
  }, [isClient]);

  const handleSelectRoom = (roomId: number) => {
    setCurrentRoomId(roomId);
    if (isClient) {
      localStorage.setItem('lastRoomId', roomId.toString());
    }
  };

  // 在客户端渲染之前显示加载状态
  if (!isClient || !nickname) {
    return (
      <div style={{ 
        display: 'flex', 
        justifyContent: 'center', 
        alignItems: 'center', 
        height: '100vh',
        fontSize: '16px',
        color: '#666'
      }}>
        加载中...
      </div>
    );
  }

  return (
    <Layout className={styles.chatLayout}>
      <Sider width={300} className={styles.sider}>
        <RoomList 
          onSelectRoom={handleSelectRoom}
          currentRoomId={currentRoomId}
          nickname={nickname}
        />
      </Sider>
      <Content className={styles.content}>
        <ChatWindow roomId={currentRoomId} />
      </Content>
    </Layout>
  );
}
