package controller

import (
	"go-svc-tpl/utils"
	"net/http"
	"time"

	"github.com/labstack/echo/v4"
	"github.com/sirupsen/logrus"
)

// set token into cookie
func setToken(c echo.Context, token string) {
	cookie := new(http.Cookie)
	cookie.Name = "token"
	cookie.Value = token
	cookie.Expires = time.Now().Add(24 * time.Hour)
	cookie.Path = "/" // set the path, or it will be /user
	c.SetCookie(cookie)
	logrus.Info("set token " + token)
}

// get token from cookie
// return "" if not found
func GetToken(c echo.Context) string {
	cookie, _ := c.Cookie("token") // 没有错误处理(?)

	if cookie == nil {
		return ""
	}
	return cookie.Value
}

// get the username by token
// return username "default" if no user is found
func getName(c echo.Context) string {
	token := GetToken(c)
	if token == "" {
		return "default"
	}
	claims, _ := utils.ParseToken(token)
	if claims == nil {
		return "default"
	}
	return claims.Username
}
