package app

import (
	"go-svc-tpl/app/controller"
	"go-svc-tpl/app/midware"
	"go-svc-tpl/app/response"

	"github.com/labstack/echo/v4"
	echoSwagger "github.com/swaggo/echo-swagger"
)

func ping(c echo.Context) error {
	return response.SendResponse(c, 0, "ok", "Pong!")
}

func addRoutes() {
	api := e.Group("api")
	api.GET("/doc/*", echoSwagger.WrapHandler)
	api.GET("/ping", ping)

	user := e.Group("user")
	user.POST("/register", controller.Register)
	user.Use(midware.Auth)
	user.POST("/login", controller.Login)
	user.POST("/logout", controller.Logout)
	user.POST("/info", controller.Info, midware.Auth)
	user.POST("/record/get", controller.GetRecord, midware.Auth)
	user.POST("/url/get", controller.GetUrl, midware.Auth)

	url := e.Group("url")
	url.Use(midware.Auth)
	url.POST("/create", controller.Create)
	url.POST("/query", controller.Query)
	url.POST("/update", controller.Update)
	url.POST("/delete", controller.Delete)
	url.POST("/pause", controller.Pause)
}
