package utils

import (
	"fmt"
	"go-svc-tpl/model"
)

var shortCounter int
var toChar map[int]string

func init() {
	shortCounter = 1145141919
	toChar = make(map[int]string)
	// radix 62
	for i := 0; i < 10; i++ {
		toChar[i] = fmt.Sprintf("%d", i)
	}
	for i := 0; i < 26; i++ {
		toChar[i+10] = fmt.Sprintf("%c", 'A'+i)
		toChar[i+36] = fmt.Sprintf("%c", 'a'+i)
	}
}

// generate shortlink
func GenShort() string {

	short := ""
	for i := shortCounter; i != 0; i /= 62 {
		short = fmt.Sprintf("%s%s", short, toChar[i%62])
	}

	shortCounter++

	// while short exists, generate again
	for model.ExistShort(short) {
		short = GenShort()
	}

	return short
}
