package app

import (
	"go-svc-tpl/app/controller"

	"github.com/labstack/echo/v4"
	echoSwagger "github.com/swaggo/echo-swagger"
)

func ping(c echo.Context) error {
	return c.String(200, "pong!")
}

func addRoutes() {
	api := e.Group("api")
	api.GET("/doc/*", echoSwagger.WrapHandler)
	api.GET("/ping", ping)

	user := e.Group("user")
	user.POST("/register", controller.Register)
	user.POST("/login", controller.Login)
	user.POST("/logout", controller.Logout)
	user.POST("/info", controller.Info)
	user.POST("/record/get", controller.GetRecord)
	user.POST("/url/get", controller.GetUrl)

	url := e.Group("url")
	url.POST("/create", controller.Create)
	url.POST("/query", controller.Query)
	url.POST("/update", controller.Update)
	url.POST("/delete", controller.Delete)
	url.POST("/pause", controller.Pause)
}
