package midware

import (
	"go-svc-tpl/app/response"
	"go-svc-tpl/utils"
	"net/http"
	"time"

	"github.com/labstack/echo/v4"
	"github.com/sirupsen/logrus"
)

// validate token
func Auth(next echo.HandlerFunc) echo.HandlerFunc {
	return func(c echo.Context) error {
		token := c.FormValue("token")

		var code int
		var msg string

		if token == "" {
			code = 0 // no login but can use
			msg = "not login yet"
		} else {
			claims, err := utils.ParseToken(token)
			if err != nil {
				code = 1
				msg = "token check fail"
				logrus.Error(err)
			} else if time.Now().Unix() > claims.ExpiresAt {
				code = 1
				msg = "token expired"
			} else {
				code = 0
			}
		}

		// if not success, abort the program
		if code != 0 {
			response.SendResponse(c, code, msg, "")
			return echo.NewHTTPError(http.StatusUnauthorized, msg)
		}

		// check pass, continue
		return next(c)
	}
}
