"use client";

import { useState, useEffect } from "react";
// 引入 authStore 和 AuthState，用于管理认证状态
import { authStore, AuthState } from "@/lib/authStore";

// 定义 useAuth 自定义钩子，返回认证状态和方法
export function useAuth() {
  const [state, setState] = useState<AuthState>(authStore.getState());

  // 使用 useEffect 订阅 authStore 的状态变化
  useEffect(() => {
    const unsubscribe = authStore.subscribe(setState);
    return unsubscribe;
  }, []);

  // 返回认证状态和方法
  return {
    ...state,
    login: authStore.login.bind(authStore), //authStore.login 方法，绑定到 authStore 上下文，用于处理登录。
    logout: authStore.logout.bind(authStore), //authStore.logout 方法，绑定到 authStore 上下文，用于处理退出登录。
    getAuthHeader: authStore.getAuthHeader.bind(authStore), //authStore.getAuthHeader 方法，绑定到 authStore 上下文，可能用于生成认证请求头（如 Authorization: Bearer token）。
  };
}
