// src/components/MessageItem/MessageItem.tsx
// 引入 Message 类型，用于定义消息的结构
import { Message } from "@/types";
import "./MessageItem.css";

// 定义 MessageItemProps 接口，描述组件接收的属
interface MessageItemProps {
  message: Message; // 消息对象，包含发送者、内容、时间等
  isCurrentUser: boolean; // 表示消息是否由当前用户发送
}

// 定义 MessageItem 组件，接收 message 和 isCurrentUser 属性
export default function MessageItem({
  message,
  isCurrentUser,
}: MessageItemProps) {
  // 定义 formatTime 函数，将时间戳格式化为本地时间
  const formatTime = (timestamp: number) => {
    return new Date(timestamp).toLocaleTimeString("zh-CN", {
      hour: "2-digit",
      minute: "2-digit",
    });
  };

  return (
    <div
      className={`message-item ${
        isCurrentUser ? "current-user" : "other-user"
      }`}
    >
      <div className="message-header">
        <span className="sender">{message.sender}</span>
        <span className="time">{formatTime(message.time)}</span>
      </div>
      <div className="message-content">{message.content}</div>
    </div>
  );
}
