// 文件位置：src/app/api/room/message/list/route.ts
import { NextResponse } from 'next/server';
import { RoomMessageListRes } from '@/types/api';
import { getRoomMessages } from '@/lib/dataStore';

export async function GET(request: Request) {
  try {
    const { searchParams } = new URL(request.url);
    const roomId = parseInt(searchParams.get('roomId') || '0');
    
    if (!roomId) {
      return NextResponse.json({
        code: 1,
        message: '房间ID必须提供'
      });
    }

    const roomMessages = getRoomMessages(roomId);
    const response: RoomMessageListRes = { messages: roomMessages };
    
    return NextResponse.json({
      code: 0,
      data: response,
    });
  } catch (error) {
    return NextResponse.json({
      code: 1,
      message: '获取消息列表失败'
    });
  }
}
