// 文件位置：src/app/api/room/message/getUpdate/route.ts
import { NextResponse } from 'next/server';
import { RoomMessageGetUpdateRes } from '@/types/api';
import { getRoomUpdateMessages } from '@/lib/dataStore';

export async function GET(request: Request) {
  try {
    const { searchParams } = new URL(request.url);
    const roomId = parseInt(searchParams.get('roomId') || '0');
    const sinceMessageId = parseInt(searchParams.get('sinceMessageId') || '0');
    
    if (!roomId) {
      return NextResponse.json({
        code: 1,
        message: '房间ID必须提供'
      });
    }

    // 获取指定房间中ID大于sinceMessageId的消息
    const newMessages = getRoomUpdateMessages(roomId, sinceMessageId);
    
    const response: RoomMessageGetUpdateRes = { messages: newMessages };
    
    return NextResponse.json({
      code: 0,
      data: response,
    });
  } catch (error) {
    return NextResponse.json({
      code: 1,
      message: '获取消息更新失败'
    });
  }
}
