// 文件位置：src/app/api/room/list/route.ts
import { NextResponse } from 'next/server';
import { RoomListRes } from '@/types/api';
import { rooms } from '@/lib/dataStore';

export async function GET() {
  try {
    const response: RoomListRes = { rooms };
    
    return NextResponse.json({
      code: 0,
      data: response,
    });
  } catch (error) {
    return NextResponse.json({
      code: 1,
      message: '获取房间列表失败'
    });
  }
}
