// 文件位置：src/types/api.ts
// API接口参数和响应类型定义

// === 创建房间 ===
export interface RoomAddArgs {
  user: string;
  roomName: string;
}

export interface RoomAddRes {
  roomId: number;
}

// === 获取房间列表 ===
export interface RoomListRes {
  rooms: import('./index').RoomPreviewInfo[];
}

// === 删除房间 ===
export interface RoomDeleteArgs {
  user: string;
  roomId: number;
}

// === 添加消息 ===
export interface MessageAddArgs {
  roomId: number;
  content: string;
  sender: string;
}

// === 获取房间消息列表 ===
export interface RoomMessageListArgs {
  roomId: number;
}

export interface RoomMessageListRes {
  messages: import('./index').Message[];
}

// === 获取消息更新 ===
export interface RoomMessageGetUpdateArgs {
  roomId: number;
  sinceMessageId: number;
}

export interface RoomMessageGetUpdateRes {
  messages: import('./index').Message[];
}

// === 通用响应格式 ===
export interface ApiResponse<T = any> {
  code: number;
  data?: T;
  message?: string;
}
