// UserInfo 是一个 React 组件，负责显示当前登录用户的信息和提供退出登录功能
// 显示用户的头像（占位符 👤）和用户名（user.username），以及一个退出登录按钮。（就是聊天室最上面那一行）
"use client";

import React from "react";
import { useAuth } from "@/hooks/useAuth";
import "./UserInfo.css";

export default function UserInfo() {
  const { isAuthenticated, user, logout } = useAuth();

  if (!isAuthenticated || !user) {
    return null;
  }

  return (
    <div className="user-info">
      <div className="user-details">
        <span className="user-avatar">👤</span>
        <span className="user-name">{user.username}</span>
      </div>
      <button onClick={logout} className="logout-button">
        退出登录
      </button>
    </div>
  );
}
