// 文件位置：src/components/SetName/SetName.tsx
"use client";
import { useState, useEffect } from "react";
import { useRouter } from "next/navigation";
import "./SetName.css";

export default function SetName() {
  const [name, setName] = useState("");
  const router = useRouter();

  // 检查是否已经设置了用户名
  useEffect(() => {
    if (typeof window !== "undefined") {
      const savedName = localStorage.getItem("userName");
      if (savedName) {
        // 如果已经有用户名，直接跳转到聊天室
        router.push("/chatroom");
      }
    }
  }, [router]);

  const handleSubmit = () => {
    if (name.trim()) {
      // 保存用户名到localStorage
      localStorage.setItem("userName", name.trim());
      // 跳转到聊天室页面
      router.push("/chatroom");
    }
  };

  const handleKeyDown = (e: React.KeyboardEvent) => {
    if (e.key === "Enter" && name.trim()) {
      handleSubmit();
    }
  };

  return (
    <div className="setname-container">
      <div className="setname-card">
        <h1 className="setname-title">设置昵称</h1>
        <p className="setname-subtitle">请输入您的昵称以开始聊天</p>

        <div className="setname-form">
          <input
            type="text"
            value={name}
            onChange={(e) => setName(e.target.value)}
            onKeyDown={handleKeyDown}
            placeholder="请输入昵称"
            className="setname-input"
            maxLength={20}
            autoFocus
          />

          <button
            onClick={handleSubmit}
            disabled={!name.trim()}
            className="setname-button"
          >
            进入聊天室
          </button>
        </div>

        <div className="setname-tips">
          <p>💡 提示：昵称将作为您在聊天室中的显示名称</p>
        </div>
      </div>
    </div>
  );
}
