import { NextResponse } from "next/server";
import { extractUserFromRequest } from "@/lib/auth";
import { MessageAddArgs } from "@/types/api";
import { Message } from "@/types";
import { getNextMessageId, addMessage } from "@/lib/dataStore";

export async function POST(request: Request) {
  try {
    // 验证用户身份
    const user = extractUserFromRequest(request);
    if (!user) {
      return NextResponse.json({
        code: 1,
        message: "请先登录",
      });
    }

    const body = await request.json();
    const { roomId, content } = body;

    console.log("收到发送消息请求:", { roomId, content, user: user.username });

    if (!roomId || !content) {
      return NextResponse.json({
        code: 1,
        message: "房间ID和消息内容不能为空",
      });
    }

    // 创建新消息 - 使用认证用户的用户名
    const newMessage: Message = {
      messageId: getNextMessageId(),
      roomId: roomId,
      sender: user.username, // 使用认证用户的用户名
      content: content.trim(),
      time: Date.now(),
    };

    console.log("创建新消息:", newMessage);

    // 添加消息到共享存储
    addMessage(newMessage);

    return NextResponse.json({
      code: 0,
      message: "消息发送成功",
    });
  } catch (error) {
    console.error("发送消息失败:", error);
    return NextResponse.json({
      code: 1,
      message: "发送消息失败",
    });
  }
}
