import { NextRequest, NextResponse } from 'next/server';
import { extractUserFromRequest } from '@/lib/auth';
import { userStore } from '@/lib/dataStore';
import { ApiResponse } from '@/types/api';

export async function GET(request: NextRequest) {
  try {
    const user = extractUserFromRequest(request);
    if (!user) {
      return NextResponse.json<ApiResponse>({
        code: 401,
        message: '未授权访问',
      }, { status: 401 });
    }

    // 获取完整用户信息
    const fullUser = userStore.findUserById(user.userId);
    if (!fullUser) {
      return NextResponse.json<ApiResponse>({
        code: 404,
        message: '用户不存在',
      }, { status: 404 });
    }

    return NextResponse.json<ApiResponse>({
      code: 200,
      data: {
        userId: fullUser.userId,
        username: fullUser.username,
        email: fullUser.email,
      },
      message: '获取用户信息成功',
    });

  } catch (error) {
    console.error('获取用户信息失败:', error);
    return NextResponse.json<ApiResponse>({
      code: 500,
      message: '服务器错误',
    }, { status: 500 });
  }
}
