/*
import SetName from "@/components/SetName/SetName";
import Link from "next/link";

export default function Home() {
  return (
    <>
      <div>
        <h1>Welcome to Chatroom!</h1>
        // Your Logic Here 
        <SetName />

        // 添加到聊天室的导航链接 
        <Link href="/chatroom">
          <button>进入聊天室</button>
        </Link>
      </div>
    </>
  );
}
*/
"use client";

import React, { useState } from 'react';
import SetName from "@/components/SetName/SetName";
import Link from "next/link";
import { useAuth } from '@/hooks/useAuth';
import AuthModal from '@/components/Auth/AuthModal';

export default function Home() {
  const { isAuthenticated, user } = useAuth();
  const [showAuthModal, setShowAuthModal] = useState(false);

  if (!isAuthenticated) {
    return (
      <main style={{ 
        padding: '2rem', 
        textAlign: 'center', 
        minHeight: '100vh', 
        display: 'flex', 
        flexDirection: 'column', 
        justifyContent: 'center' 
      }}>
        <h1 style={{ fontSize: '2.5rem', marginBottom: '1rem', color: '#333' }}>
          Welcome to Chatroom!
        </h1>
        <p style={{ fontSize: '1.2rem', color: '#666', marginBottom: '2rem' }}>
          请登录或注册以开始与其他用户聊天
        </p>
        <button 
          onClick={() => setShowAuthModal(true)}
          style={{
            padding: '0.75rem 2rem',
            background: '#007bff',
            color: 'white',
            border: 'none',
            borderRadius: '8px',
            cursor: 'pointer',
            fontSize: '1.1rem',
            fontWeight: '500',
            margin: '0 auto',
            display: 'block',
            boxShadow: '0 2px 4px rgba(0, 123, 255, 0.3)',
          }}
        >
          开始聊天
        </button>
        
        <AuthModal
          isOpen={showAuthModal}
          onClose={() => setShowAuthModal(false)}
        />
      </main>
    );
  }

  return (
    <div>
      <div style={{ 
        background: '#f8f9fa', 
        padding: '1rem', 
        borderBottom: '1px solid #e9ecef',
        display: 'flex',
        justifyContent: 'space-between',
        alignItems: 'center'
      }}>
        <h1>Welcome to Chatroom!</h1>
        <div style={{ display: 'flex', alignItems: 'center', gap: '1rem' }}>
          <span>欢迎, {user?.username}!</span>
        </div>
      </div>
      
      <div style={{ padding: '2rem' }}>
        <SetName />
        
        <Link href="/chatroom">
          <button style={{
            padding: '0.75rem 1.5rem',
            background: '#007bff',
            color: 'white',
            border: 'none',
            borderRadius: '4px',
            cursor: 'pointer',
            fontSize: '1rem',
            marginTop: '1rem'
          }}>
            进入聊天室
          </button>
        </Link>
      </div>
    </div>
  );
}
