// src/types/index.ts
export interface Message {
  messageId: number;    // 消息 id
  roomId: number;       // 房间 id
  sender: string;       // 发送人的 username
  content: string;      // 消息内容
  time: number;         // 消息发送时间戳
}

export interface RoomPreviewInfo {
  roomId: number;
  roomName: string;
  // UPDATE 20230814: 这里增加了 null 的可能性
  lastMessage: Message | null;
}

// 额外添加的有用类型
export interface User {
  userId: number;
  username: string;
  isOnline?: boolean;
}

export interface ChatRoomData {
  roomId: number;
  roomName: string;
  messages: Message[];
  participants: User[];
}

// 导出API类型
export * from './api';
