// 用户认证相关类型
// 这个接口表示用户的 登录凭据，即用户用来登录的 用户名 和 密码。
export interface UserCredentials {
  username: string;
  password: string;
}

//这个接口表示 注册时 传递的参数，它继承了 UserCredentials 接口（意味着注册时也需要用户名和密码），并且新增了一个可选的 电子邮件 字段。
export interface RegisterArgs extends UserCredentials {
  email?: string;
}

export interface LoginArgs extends UserCredentials {}

// 这个接口表示 认证响应，即用户成功登录后，后端返回的用户信息和 JWT token。它包含了用户的基本信息和一个 JWT token，该 token 用于后续的身份验证。
export interface AuthResponse {
  user: {
    userId: number;
    username: string;
    email?: string;
  };
  token: string;
}

// 这个接口表示 JWT payload，即存储在 JWT token 中的用户信息。JWT token 是一个自包含的令牌，包含用户认证所需的最小信息，这些信息是经过加密后可以验证的。
export interface JWTPayload {
  userId: number; // 用户的唯一 ID，类型为 number
  username: string; // 用户的用户名，类型为 string。
  iat: number; //表示 token 颁发的时间戳，类型为 number（单位是秒）。
  exp: number; //表示 token 过期的时间戳，类型为 number（单位是秒）。
}

// 认证用户信息 (用于API中间件)
// 这个接口表示 已认证用户，即认证过程完成后，系统中表示用户身份的最简信息
export interface AuthenticatedUser {
  userId: number;
  username: string;
}
