// src/components/RoomEntry/RoomEntry.tsx
// 引入 RoomPreviewInfo 类型，用于定义聊天室预览信息的结构
import { RoomPreviewInfo } from "@/types";
import "./RoomEntry.css";

interface RoomEntryProps {
  room: RoomPreviewInfo; // 聊天室预览信息
  isActive: boolean; // 表示该聊天室是否当前选中
  onClick: (roomId: number) => void; // 点击聊天室时的回调函数
  onContextMenu?: (e: React.MouseEvent, roomId: number) => void; // 可选的右键菜单回调函数
}

export default function RoomEntry({
  room,
  isActive,
  onClick,
  onContextMenu,
}: RoomEntryProps) {
  const formatTime = (timestamp?: number) => {
    if (!timestamp) return "";
    return new Date(timestamp).toLocaleTimeString("zh-CN", {
      hour: "2-digit",
      minute: "2-digit",
    });
  };

  return (
    <div
      className={`room-entry ${isActive ? "active" : ""}`}
      onClick={() => onClick(room.roomId)}
      onContextMenu={(e) => onContextMenu?.(e, room.roomId)}
    >
      <div className="room-header">
        <h3 className="room-name">{room.roomName}</h3>
        {room.lastMessage && (
          <span className="last-time">{formatTime(room.lastMessage.time)}</span>
        )}
      </div>

      <div className="room-preview">
        {room.lastMessage ? (
          <p className="last-message">
            <span className="sender">{room.lastMessage.sender}:</span>
            <span className="content">{room.lastMessage.content}</span>
          </p>
        ) : (
          <p className="no-message">暂无消息</p>
        )}
      </div>
    </div>
  );
}
