// React 弹窗组件（AuthModal），用于显示登录或注册表单
// 声明这是一个客户端组件，告诉 Next.js 这个组件只在浏览器端运行
"use client";

// 引入 React 和 useState 钩子，用于管理组件的状态
//useState 是 React 的函数式组件中用于声明和管理状态的钩子函数。它返回一个数组，包含当前状态值和更新状态的函数。
import React, { useState } from "react";
// 引入 LoginForm 和 RegisterForm 两个子组件，分别处理登录和注册的表单
import LoginForm from "./LoginForm";
import RegisterForm from "./RegisterForm";
import "./Auth.css";

// 定义 AuthModalProps 接口，描述组件接收的属性（props）
interface AuthModalProps {
  isOpen: boolean;
  onClose: () => void;
  onSuccess?: () => void;
}

// 定义 AuthMode 类型，表示弹窗的两种模式：登录或注册
type AuthMode = "login" | "register";

// 定义 AuthModal 组件，接收 isOpen、onClose、onSuccess 三个属性
export default function AuthModal({
  isOpen,
  onClose,
  onSuccess,
}: AuthModalProps) {
  // 使用 useState 钩子管理弹窗的模式，初始值是 'login'
  const [mode, setMode] = useState<AuthMode>("login");

  // 定义 handleSuccess 函数，处理登录或注册成功后的逻辑
  const handleSuccess = () => {
    onSuccess?.();
    onClose();
  };

  if (!isOpen) return null;

  // 渲染弹窗的 HTML 结构
  return (
    <div className="auth-modal-overlay" onClick={onClose}>
      <div className="auth-modal-content" onClick={(e) => e.stopPropagation()}>
        <button className="auth-modal-close" onClick={onClose}>
          ×
        </button>

        {mode === "login" ? (
          <LoginForm
            onSuccess={handleSuccess}
            switchToRegister={() => setMode("register")}
          />
        ) : (
          <RegisterForm
            onSuccess={handleSuccess}
            switchToLogin={() => setMode("login")}
          />
        )}
      </div>
    </div>
  );
}
