/** @type {import('next').NextConfig} */
const nextConfig = {
  // Enable standalone output for Docker deployment
  output: "standalone",

  // Disable telemetry
  experimental: {
    // This is needed for standalone output
    outputFileTracingRoot: undefined,
  },

  // Configure images for Docker environment
  images: {
    unoptimized: true,
  },

  // Environment variables
  env: {
    JWT_SECRET: process.env.JWT_SECRET,
  },
};

module.exports = nextConfig;
