// chatroom/src/app/greet/page.tsx
'use client';

import { useEffect, useState } from 'react';
import { useRouter } from 'next/navigation';
import styles from './greet.module.css'; // 改为 module.css

export default function GreetPage() {
  const [nickname, setNickname] = useState('');
  const router = useRouter();

  useEffect(() => {
    const savedNickname = localStorage.getItem('nickname');
    if (!savedNickname) {
      alert('请先设置昵称');
      router.push('/setname');
    } else {
      setNickname(savedNickname);
    }
  }, [router]);

  useEffect(() => {
    const timer = setTimeout(() => {
      router.push('/chat')
    }, 3000);
    return () => clearTimeout(timer); // 清理定时器
  }, [router]);

  return (
    <div className={styles.container}>
      <h1 className={styles.title}>欢迎，{nickname}！</h1>
      <p className={styles.subtitle}>即将进入聊天室...</p>
      <div className={styles.loader}></div>
    </div>
  );
}