// chatroom/src/app/api/room/list/route.ts
import { NextResponse } from 'next/server';
import { PrismaClient } from '@prisma/client';

const prisma = new PrismaClient();

export async function GET() {
  // 先拿房间
  const rooms = await prisma.room.findMany({ orderBy: { id: 'asc' } });

  // 再补最后一条消息
  const data = await Promise.all(
    rooms.map(async (r) => {
      const lastMsg = await prisma.message.findFirst({
        where: { roomId: r.id },
        orderBy: { createdAt: 'desc' },
      });
      return {
        roomId: r.id,
        roomName: r.name,
        lastMessage: lastMsg
          ? {
              messageId: lastMsg.id,
              roomId: lastMsg.roomId,
              sender: lastMsg.sender,
              content: lastMsg.content,
              time: lastMsg.createdAt.getTime(),
            }
          : null,
      };
    })
  );

  return NextResponse.json({ code: 0, data: { rooms: data } });
}