// chatroom/src/app/api/room/add/route.ts

import { NextRequest, NextResponse } from 'next/server';
import { PrismaClient } from '@prisma/client';
import jwt from 'jsonwebtoken';

const prisma = new PrismaClient();
const JWT_SECRET = process.env.JWT_SECRET || 'dev_secret';

export async function POST(req: NextRequest) {
  const token = req.headers.get('authorization')?.split(' ')[1];
  if (!token) return NextResponse.json({ code: 1, message: '未登录' }, { status: 401 });

  try {
    // 验证 token
    jwt.verify(token, JWT_SECRET);

    const { roomName } = await req.json();
    if (!roomName || typeof roomName !== 'string' || roomName.trim() === '') {
      return NextResponse.json({ code: 1, message: '房间名不能为空' }, { status: 400 });
    }
    
    console.log(`正在创建房间: ${roomName.trim()}`);
    const newRoom = await prisma.room.create({ data: { name: roomName.trim() } });
    console.log(`房间创建成功, ID: ${newRoom.id}`);

    return NextResponse.json({ code: 0, data: { roomId: newRoom.id } });
  } catch (error) {
    // <-- 修正：捕获并记录详细错误信息
    console.error('创建房间失败:', error); 
    const message = error instanceof Error ? error.message : '未知服务器错误';
    return NextResponse.json({ code: 1, message: `创建房间失败: ${message}` }, { status: 500 });
  }
}