// chatroom/src/lib/fetcher.ts
// 使用本地API
const prefix = ''; // 空字符串，使用相对路径

export async function authFetch(
  path: string,
  init: RequestInit = {}
) {
  const token = typeof window !== 'undefined' ? localStorage.getItem('token') : null;

  // 构造 headers 对象
  const headers: Record<string, string> = {
    'Content-Type': 'application/json',
    ...Object(init.headers || {}),
  };
  
  // 确保 token 存在时才添加 Authorization header
  if (token) {
    headers.Authorization = `Bearer ${token}`;
  }

  try {
    const response = await fetch(prefix + path, { 
      ...init, 
      headers,
    });
    
    if (!response.ok) {
      const errorData = await response.json().catch(() => ({}));
      throw new Error(errorData.message || `HTTP error! status: ${response.status}`);
    }
    
    return response;
  } catch (error) {
    console.error('Fetch error:', error);
    throw error;
  }
}