// chatroom/src/app/login/page.tsx
'use client';
import { useState } from 'react';
import { useRouter } from 'next/navigation';
import styles from './page.module.css';

export default function LoginPage() {
  const [username, setU] = useState('');
  const [password, setP] = useState('');
  const router = useRouter();

  const login = async () => {
    const res = await fetch('/api/auth/login', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ username, password }),
    });
    const json = await res.json();
    if (json.code !== 0) return alert(json.message);

    localStorage.setItem('token', json.data.accessToken);
    localStorage.setItem('nickname', username);
    router.push('/setname');
  };

  return (
    <div className={styles.container}>
      <div className={styles.card}>
        <h1 className={styles.title}>登录</h1>
        <input 
          className={styles.input}
          placeholder="用户名" 
          value={username} 
          onChange={e => setU(e.target.value)} 
        />
        <input 
          className={styles.input}
          placeholder="密码" 
          type="password" 
          value={password} 
          onChange={e => setP(e.target.value)} 
        />
        <button className={styles.button} onClick={login}>
          GET IN
        </button>
        <p className={styles.footer}>
          没有账号？<a href="/signup" className={styles.link}>去注册</a>
        </p>
      </div>
    </div>
  );
}