// chatroom/src/app/signup/page.tsx
'use client';

import { useState } from 'react';
import { useRouter } from 'next/navigation';

export default function SignupPage() {
  const [username, setU] = useState('');
  const [password, setP] = useState('');
  const [confirmPwd, setC] = useState('');
  const router = useRouter();

  const signup = async () => {
    if (!username.trim() || !password.trim()) return alert('用户名和密码不能为空');
    if (password !== confirmPwd) return alert('两次密码不一致');

    const res = await fetch('/api/auth/signup', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ username, password }),
    });
    const json = await res.json();
    if (json.code !== 0) return alert(json.message);

    alert('注册成功！请登录');
    router.push('/login');
  };

  return (
    <main style={{ padding: '2rem', textAlign: 'center' }}>
      <h1>注册账号</h1>
      <input placeholder="用户名" value={username} onChange={e => setU(e.target.value)} /><br />
      <input placeholder="密码" type="password" value={password} onChange={e => setP(e.target.value)} /><br />
      <input placeholder="确认密码" type="password" value={confirmPwd} onChange={e => setC(e.target.value)} /><br />
      <button onClick={signup}>注册</button>
      <p>已有账号？<a href="/login">去登录</a></p>
    </main>
  );
}