// chatroom/src/app/setname/page.tsx
'use client';

import { useState } from 'react';
import { useRouter } from 'next/navigation';

export default function NicknamePage() {
  const [nickname, setNickname] = useState('');
  const router = useRouter();

  const handleEnterChat = () => {
    if (!nickname.trim()) {
      alert('请输入昵称');
      return;
    }

    // 将昵称保存在 localStorage 中（暂时作为模拟）
    localStorage.setItem('nickname', nickname);

    // 跳转到聊天室页面
    router.push('/greet');
  };

  return (
    <main style={{ padding: '2rem', textAlign: 'center' }}>
      <h1>设置你的昵称</h1>
      <input
        type="text"
        placeholder="请输入昵称"
        value={nickname}
        onChange={(e) => setNickname(e.target.value)}
        style={{
          padding: '0.5rem',
          fontSize: '1rem',
          width: '200px',
          margin: '1rem 0',
        }}
      />
      <br />
      <button
        onClick={handleEnterChat}
        style={{
          padding: '0.5rem 1rem',
          fontSize: '1rem',
          cursor: 'pointer',
        }}
      >
        进入聊天室
      </button>
    </main>
  );
}
